#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// FM Polyrhythm 2Mod01.fsh  by   MrHAX00  
//https://www.shadertoy.com/view/MctGD7
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
// the sound component of original is ommitted
//common
#define pi 3.14159

#define MaxNoteHits 50.
#define EchoCount 3
#define EchoDelay 1.5
// use this to go past 180 seconds
#define LoopOffset 0.

#define NoteCount 32.

// used for visualising only
#define NoteRoundness .2
#define NoteSpacing .1

// from https://www.shadertoy.com/view/4djSRW
vec3 hash31(float p)
{
   vec3 p3 = fract(vec3(p) * vec3(.1031, .1030, .0973));
   p3 += dot(p3, p3.yzx+33.33);
   return fract((p3.xxy+p3.yzz)*p3.zyx); 
}
//end common

float BiSmoothStep(float Center, float Distance, float UpperBlur, float LowerBlur, float Value)
{
    float Sum = smoothstep(Center - Distance - LowerBlur, Center - Distance, Value);
    Sum *= smoothstep(Center + Distance + UpperBlur, Center + Distance, Value);
    
    return Sum;
}

const float NoteSize = 1. / NoteCount;
float SliderSDF(vec2 Point, float NoteSlider, float NoteTime)
{
    float NoteLowerBlur = pow(1. - NoteTime, 7.) * .2;
    float NoteUpperBlur = pow(NoteTime, 7.) * .2;
    
    vec2 MinVec = vec2(-NoteSize * NoteSpacing, NoteSlider -.5 + NoteSize * NoteRoundness - NoteLowerBlur);
    vec2 MaxVec = vec2(NoteSize * NoteSpacing, NoteSlider -.5 - NoteSize * NoteRoundness + .1 + NoteUpperBlur);
    
    Point.x = mod(Point.x, NoteSize) - NoteSize * .5;
    return length(clamp(Point, MinVec, MaxVec) - Point) - NoteSize * NoteRoundness;
}

vec4 DrawSliders(vec2 uv)
{
    float NoteIndex = NoteCount - floor((uv.x + .5) * NoteCount) - 1.;
    float NoteSpan = 180. / (MaxNoteHits - NoteIndex);
    float NoteTime = fract((iTime + LoopOffset * 180.) / NoteSpan);
    
    float EchoTime = 1.;
    float Echo = 0.;
    for (float i = 0.; i < float(EchoCount); i++)
    {
        float Current = fract((iTime + LoopOffset * 180. - i * EchoDelay) / NoteSpan);
        EchoTime = min(EchoTime, Current);
        Echo = Current == EchoTime? i : Echo;
    }
    
    float NoteSlider = pow(1. - (cos(NoteTime * pi * 2.) * .5 + .5), .375) * .9;
    
    float Note = SliderSDF(uv, NoteSlider, NoteTime);
    float NoteColor = smoothstep(max(pow(1. - EchoTime, 10.) * .05 / (pow(1. + NoteTime, 3.)), .001), 0., Note);
    NoteColor *= smoothstep(NoteSlider -.5 + NoteSize * NoteRoundness + .2, NoteSlider -.5 + NoteSize * NoteRoundness + .1, uv.y);
    NoteColor *= smoothstep(NoteSlider -.5 + NoteSize * NoteRoundness - .1, NoteSlider -.5 + NoteSize * NoteRoundness, uv.y);
    
    return vec4(hash31(NoteIndex + floor((iTime + LoopOffset * 180.) / NoteSpan) * .23) * .8 + .2, NoteColor * .8);
}

vec3 DrawBG(vec2 uv)
{
    float NoteIndex = NoteCount - floor((uv.x + .5) * NoteCount) - 1.;
    float NoteSpan = 180. / (MaxNoteHits - NoteIndex);
    
    float NoteTime = 1.;
    float Echo = 0.;
    for (float i = 0.; i < float(EchoCount); i++)
    {
        float Current = fract((iTime + LoopOffset * 180. - i * EchoDelay) / NoteSpan);
        NoteTime = min(NoteTime, Current);
        Echo = Current == NoteTime? i : Echo;
    }
    
    float BGMix = BiSmoothStep(.5, pow(1. - NoteTime, 2.) * .35, .001, .001, fract(uv.x * NoteCount));
    BGMix += BiSmoothStep(.5, .05 - NoteTime, .5, .5, fract(uv.x * NoteCount) - cos(uv.y * pi * 10. - iTime * pi) * (.25 - pow(1. - NoteTime, 10.)));
    
    vec3 BGRowColor = hash31(NoteIndex + floor((iTime + LoopOffset * 180.) / NoteSpan) * .23);
    vec3 BG = mix(BGRowColor * .1 + pow(1. - NoteTime, 15.), BGRowColor * .3 + pow(1. - NoteTime, 3.), BGMix);
    float BGTransparency = pow(1. - NoteTime, 10.) * pow(.5 - uv.y, pow(1. - NoteTime, 80.) * 15.);
    BG = mix(texelFetch(texture0, ivec2(fract(abs(uv)) * 2. * 1024.), 0).xyz * .08, BG, max(BGTransparency - pow(Echo / float(EchoCount), .8) * .5, 0.));
    
    return BG;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord - iResolution.xy * .5) / iResolution.y;
    vec4 Sliders = DrawSliders(uv);
    vec3 BG = DrawBG(uv);
    
    vec3 Sum = mix(BG, Sliders.xyz, Sliders.w);
    
    Sum = mix(BG * .05 + .1, Sum, BiSmoothStep(0., .5, .0001, .0001, uv.x));
    fragColor = vec4(Sum, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

